<?php
/**
 * see jISelector.iface.php for documentation about selectors.
 *
 * @package     jelix
 * @subpackage  core_selector
 *
 * @author      Laurent Jouanneau
 * @contributor Thibault Piront (nuKs)
 *
 * @copyright   2005-2012 Laurent Jouanneau
 * @copyright   2007 Thibault Piront
 *
 * @see        http://www.jelix.org
 * @licence    GNU Lesser General Public Licence see LICENCE file or http://www.gnu.org/licenses/lgpl.html
 */

/**
 * Generic Action selector.
 *
 * main syntax: "module~action@requestType". module should be a valid module name or # (#=says to get
 * the module of the current request). action should be an action name (controller:method or controller_method).
 * all part are optional, but it should have one part at least.
 *
 * @package    jelix
 * @subpackage core_selector
 */
class jSelectorAct extends jSelectorActFast
{
    protected $forUrl = false;

    /**
     * @param string $sel               the selector
     * @param bool   $enableRequestPart true if the selector can contain the request part
     * @param bool   $toRetrieveUrl     true if the goal to have this selector is to generate an url
     *
     * @throws jExceptionSelector
     */
    public function __construct($sel, $enableRequestPart = false, $toRetrieveUrl = false)
    {
        $coord = jApp::coord();
        $this->forUrl = $toRetrieveUrl;

        // jSelectorAct is called by the url engine parser, before
        // jcoordinator set its properties, so we set a value to avoid a
        // parameter error on jelix_scan_action_sel. the value doesn't matter
        // since the parser call jSelectorAct only for 404 page
        if ($coord->actionName === null) {
            $coord->actionName = 'default:index';
        }

        if (jelix_scan_action_sel($sel, $this, $coord->actionName)) {
            if ($this->module == '#') {
                $this->module = $coord->moduleName;
            } elseif ($this->module == '') {
                $this->module = jApp::getCurrentModule();
            }

            if ($this->request == '' || !$enableRequestPart) {
                if ($coord->request) {
                    $this->request = $coord->request->type;
                }
                else {
                    // In the context of a cli command, we don't have request object...
                    $this->request = 'classic';
                }
            }

            $this->_createPath();
        } else {
            throw new jExceptionSelector('jelix~errors.selector.invalid.syntax', array($sel, $this->type));
        }
    }

    protected function _createPath()
    {
        $conf = jApp::config();
        if (isset($conf->_modulesPathList[$this->module])) {
            $p = $conf->_modulesPathList[$this->module];
        } else {
            throw new jExceptionSelector('jelix~errors.selector.module.unknown', $this->toString());
        }

        $this->_path = $p.'controllers/'.$this->controller.'.'.$this->request.'.php';
    }
}
