
CREATE TABLE IF NOT EXISTS %%PREFIX%%JACL2_GROUP (
    ID_ACLGRP VARCHAR2(60 CHAR) NOT NULL,
    NAME VARCHAR2(150 CHAR) NOT NULL,
    GROUPTYPE NUMBER(3,0) NOT NULL,
    OWNERLOGIN VARCHAR2(50 CHAR),
    CONSTRAINT %%PREFIX%%JACL2_GROUP_PK PRIMARY KEY (ID_ACLGRP)
);

CREATE TABLE IF NOT EXISTS %%PREFIX%%JACL2_SUBJECT_GROUP (
    ID_ACLSBJGRP VARCHAR2( 50 CHAR ) NOT NULL ,
    LABEL_KEY VARCHAR2( 60 CHAR ) NOT NULL ,
    CONSTRAINT %%PREFIX%%JACL2_SUBJECT_GROUP_PK PRIMARY KEY (ID_ACLSBJGRP)
);

CREATE TABLE IF NOT EXISTS %%PREFIX%%JACL2_SUBJECT (
    ID_ACLSBJ VARCHAR2(100 CHAR) NOT NULL,
    LABEL_KEY VARCHAR2(100 CHAR) DEFAULT NULL,
    ID_ACLSBJGRP VARCHAR2( 50 CHAR ) DEFAULT NULL,
    CONSTRAINT %%PREFIX%%JACL2_SUBJECT_PK PRIMARY KEY (ID_ACLSBJ),
    CONSTRAINT %%PREFIX%%JACL2_SUBJECT_FK FOREIGN KEY (ID_ACLSBJGRP) REFERENCES %%PREFIX%%JACL2_SUBJECT_GROUP(ID_ACLSBJGRP)
);

CREATE TABLE IF NOT EXISTS %%PREFIX%%JACL2_USER_GROUP (
    LOGIN VARCHAR2(50 CHAR) NOT NULL,
    ID_ACLGRP VARCHAR2(60 CHAR) NOT NULL,
    CONSTRAINT %%PREFIX%%JACL2_USER_GROUP_PK PRIMARY KEY (LOGIN, ID_ACLGRP),
    CONSTRAINT %%PREFIX%%JACL2_USER_GROUP_FK FOREIGN KEY (ID_ACLGRP) REFERENCES %%PREFIX%%JACL2_GROUP(ID_ACLGRP)
);

CREATE TABLE IF NOT EXISTS %%PREFIX%%JACL2_RIGHTS (
    ID_ACLSBJ VARCHAR2(255 CHAR) NOT NULL,
    ID_ACLGRP VARCHAR2(60 CHAR) NOT NULL,
    ID_ACLRES VARCHAR2(100 CHAR) NOT NULL DEFAULT '-',
    CANCELED NUMBER(3,0) DEFAULT '0',
    CONSTRAINT %%PREFIX%%JACL2_RIGHTS_PK PRIMARY KEY (ID_ACLSBJ, ID_ACLGRP, ID_ACLRES),
    CONSTRAINT %%PREFIX%%JACL2_RIGHTS_FK_1 FOREIGN KEY (ID_ACLGRP) REFERENCES %%PREFIX%%JACL2_GROUP(ID_ACLGRP),
    CONSTRAINT %%PREFIX%%JACL2_RIGHTS_FK_2 FOREIGN KEY (ID_ACLSBJ) REFERENCES %%PREFIX%%JACL2_SUBJECT(ID_ACLSBJ)
);
